/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include "mx_auto_config.h"
#include "myriexpress.h"
#include <stdio.h>
#if MX_OS_WINNT
#include "getopt.h"
#else
#include <unistd.h>
#include <netinet/in.h>
#endif
#include <string.h>
#include <stdlib.h>
#include <stddef.h>
#include <assert.h>

#include "mx__lib_types.h"

typedef struct event_node
{
  struct event_node *prev;
  struct event_node *next;

  uint32_t seqnum;
  uint32_t cpuc;
  uint32_t event;
} event_node_t;

void
list_init(event_node_t *x)
{
  x->prev = x->next = x;
}

event_node_t *
list_begin(event_node_t *x)
{
  return x->next;
}

event_node_t *
list_end(event_node_t *x)
{
  return x;
}

event_node_t *
list_insert(event_node_t *x, uint32_t seqnum, uint32_t cpuc, uint32_t event)
{
  event_node_t *y;

  y = malloc(sizeof (*y));
  if (y != NULL) {
    y->seqnum = seqnum;
    y->cpuc = cpuc;
    y->event = event;
    x->prev->next = y;
    y->prev = x->prev;
    y->next = x;
    x->prev = y;
  }
  return y;
}

event_node_t *
list_insert_head(event_node_t *x, uint32_t seqnum, uint32_t cpuc, uint32_t event)
{
  return list_insert(list_begin(x), seqnum, cpuc, event);
}

event_node_t *
list_insert_tail(event_node_t *x, uint32_t seqnum, uint32_t cpuc, uint32_t event)
{
  return list_insert(list_end(x), seqnum, cpuc, event);
}

event_node_t *
list_remove(event_node_t *x)
{
  x->prev->next = x->next;
  x->next->prev = x->prev;
  return x;
}

#define insist(e) \
do { if (!(e)) printf ("%s %s %d\n", #e, __FILE__, __LINE__); } while (0)

#if 0
#undef insist
#define insist assert
#endif

void
usage()
{
  fprintf(stderr, "Usage: mx_logging [args]\n");
  fprintf(stderr, "-b - Board number [0]\n");
  fprintf(stderr, "-s samples - number of events to retrieve [256]\n");
  fprintf(stderr, "-h - help\n");
}

int 
main(int argc, char **argv)
{
#if 0
  int fd;
  extern char *optarg;
  int c;
  mx_return_t ret;
  mx_get_logging_t get_logging;
  mx_get_logging_strings_t *names;
  mx_get_logging_strings_t tmp;
  mcp_log_t *buffer;
  uint32_t board, size, samples, i;

  event_node_t e, *f, *g;
  char *p;
  int colors[256][3];
  int color[5] = { 0, 64, 128, 192, 255 };
  int red, green, blue;

  board = 0;
  samples = 256;
  while ((c = getopt(argc, argv, "hs:b:"))!= EOF) switch(c) {
  case 's':
    samples = atoi(optarg);
    break;
  case 'b':
     board = atoi(optarg);
    break;
  case 'h':
  default:
    usage();
    exit(1);
  }

  if (samples == 0) {
    fprintf(stderr, "Invalid number of events");
    usage();
    exit(1);
  }

  size = (2 * samples * sizeof (mcp_log_t));
  buffer = (mcp_log_t *) malloc(size);
  if (buffer == 0) {
    perror("buffer allocation failed");
    return 0;
  }
  bzero(buffer, size);

  mx_init();
  mx_set_error_handler(MX_ERRORS_RETURN);
  ret = mx_open_any_board(&fd, 0);
  if (ret != MX_SUCCESS) {
    printf("open failed: %s\n", mx_strerror(ret));
    free(buffer);
    return 0;
  }

  tmp.count = 0;
  if (mx__get_logging_strings(fd, board, &tmp) != 0) {
    perror("get logging count failed");
    free(buffer);
    goto abort_with_fd;
  }
  names = malloc (offsetof(mx_get_logging_strings_t, label) + 128 * tmp.count);
  if (names == NULL) {
    printf("out of memory\n");
    free(buffer);
    goto abort_with_fd;
  }
  names->count = tmp.count;
  if (mx__get_logging_strings(fd, board, names) != 0) {
    perror("get logging strings failed");
    free(names);
    free(buffer);
    goto abort_with_fd;
  }

  get_logging.board_number = board;
  get_logging.size = size;
  get_logging.buffer = (uintptr_t) buffer; 

  if (mx__get_logging(fd, &get_logging) != 0) {
    perror("get logging failed");
    free(names);
    free(buffer);
    goto abort_with_fd;
  }

  /* consistency checks */
#if 1
  insist((ntohl(buffer[0].event.event) % 2) == 0); 
  insist((ntohl(buffer[1].event.event) % 2) == 1);
  insist((ntohl(buffer[0].event.event) + 1) == (ntohl(buffer[1].event.event)));
  for (i = 1; i < samples; i ++) {
    insist((ntohl(buffer[(2 * i)].event.event) % 2) == 0); 
    insist((ntohl(buffer[((2 * i) + 1)].event.event) % 2) == 1);
    insist((ntohl(buffer[(2 * i)].event.event) + 1) 
	   == (ntohl(buffer[((2 * i) + 1)].event.event)));
  }
#endif

#if 0
  for (i = 0; i < samples*2; ++i) {
    printf("%d %u %u %u\n",
	   i, ntohl(buffer[i].seqnum), ntohl(buffer[i].event.cpuc), ntohl(buffer[i].event.event));
  }
#endif

  /* convert spaces to underscore */
  for (i = 0; i < names->count; ++i) {
    while ((p = strrchr(names->label[i], ' ')) != NULL) {
      *p = '_';
    }
  }

  /* initialize color array */
  i = 0;
  for (red = 0; red < 5; ++red) {
    for (green = 0; green < 5; ++green) {
      for (blue = 0; blue < 5; ++blue) {
	colors[i][0] = color[red];
	colors[i][1] = color[green];
	colors[i][2] = color[blue];
	++i;
      }
    }
  }

  for (i = 0; i < names->count; ++i) {
    printf("Category[ index=%d name=%s topo=State color=(%d,%d,%d,127,true) width=1 ]\n",
	   i, names->label[i], colors[i][0], colors[i][1], colors[i][2]);
  }

  list_init(&e);
  for (i = 0; i < samples*2; ++i) {
    if (ntohl(buffer[i].event.event) & 1) {
      /* odd - end event */
      f = list_begin(&e);
      g = list_end(&e);
      for (; f != g; f = f->next) {
	if (f->event == ntohl(buffer[i].event.event)-1) {
	  /* found corresponding start event */
	  f = list_remove(f);
	  printf("Primitive[ TimeBBox(%u,%u) Category=%u (%u, 0) (%u, 0) ]\n",
		 f->cpuc, ntohl(buffer[i].event.cpuc), f->event/2, f->cpuc, ntohl(buffer[i].event.cpuc));
	  free(f);
	  break;
	}
      }
    }
    else {
      /* even - start event */
      f = list_insert_head(&e, ntohl(buffer[i].seqnum), ntohl(buffer[i].event.cpuc), ntohl(buffer[i].event.event));
      if (f == NULL) {
	printf("narf!\n");
	exit(1);
      }
    }
  }

  free(names);
  free(buffer);

 abort_with_fd:
  close(fd);
  mx_finalize();

#endif
  return 0;
}
